﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Linq
Imports System.Text
Imports System.Windows.Forms
Imports Unitronics.ComDriver
Imports Unitronics.ComDriver.Messages.DataRequest
Imports System.Runtime.Remoting.Messaging
Imports System.Reflection

Public Class Form1

    Private plc As PLC
    Delegate Sub SetControlValueCallback(ByVal oControl As Control, ByVal propName As String, ByVal propValue As Object)

    Public Sub New()

        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        setButtonsEnableState(False)
        ' Add any initialization after the InitializeComponent() call.

    End Sub

    Private Sub setButtonsEnableState(ByVal value As Boolean)
        Connect.Enabled = Not value
        Reset.Enabled = value
        Init.Enabled = value
        plcStop.Enabled = value
        Run.Enabled = value
        Disconnect.Enabled = value
        Read.Enabled = value
        ReadAsynch.Enabled = value
        Write.Enabled = value
    End Sub

    Private Sub Connect_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Connect.Click
        Dim ethernet As New Ethernet("192.168.0.1", 20256, EthProtocol.TCP, 3, 3000)


        Try
            plc = PLCFactory.GetPLC(ethernet, 0)
            setButtonsEnableState(True)
            Dim version As PlcVersion = plc.Version
            txtModel.Text = version.OPLCModel
            txtHW.Text = version.HWVersion
            txtOS.Text = version.OSVersion
            txtBoot.Text = version.Boot
            txtBinLib.Text = version.BinLib
            txtFactoryBoot.Text = version.FactoryBoot
            Try
                txtPlcName.Text = plc.PlcName
            Catch
            End Try
        Catch
            setButtonsEnableState(False)
            ethernet.Disconnect()
            System.Windows.Forms.MessageBox.Show("Could not establish a connection to the PLC")
        End Try
    End Sub

    Private Sub Reset_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Reset.Click
        Try
            plc.Reset()
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Init_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Init.Click
        Try
            plc.Init()
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Stop_Click(ByVal sender As Object, ByVal e As EventArgs) Handles plcStop.Click
        Try
            plc.[Stop]()
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Run_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Run.Click
        Try
            plc.Run()
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Disconnect_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Disconnect.Click
        plc.Disconnect()
        setButtonsEnableState(False)
        txtModel.Text = ""
        txtHW.Text = ""
        txtOS.Text = ""
        txtBoot.Text = ""
        txtBinLib.Text = ""
        txtFactoryBoot.Text = ""
        txtPlcName.Text = ""
    End Sub

    Private Sub Read_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Read.Click

        Dim rw As ReadWriteRequest() = New ReadWriteRequest(0) {}
        Dim ro As ReadOperands

        ro = New ReadOperands()

        With ro
            .OperandType = OperandTypes.MI
            .NumberOfOperands = 3
            .StartAddress = 0
        End With

        rw(0) = ro

        Try
            plc.ReadWrite(rw)

            Dim values As Object() = DirectCast((rw(0).ResponseValues), Object())

            For i As Integer = 0 To values.Length - 1
                If values(i) IsNot Nothing Then
                    Dim txtbox As TextBox = TryCast(Me.groupBox1.Controls("txtMI" & i.ToString()), TextBox)
                    txtbox.Text = CShort(values(i)).ToString()
                End If
            Next
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub Write_Click(ByVal sender As Object, ByVal e As EventArgs) Handles Write.Click
        Dim values As Object() = New Object(2) {}
        Try
            values(0) = DirectCast(Int16.Parse(txtMI0.Text), Object)
            values(1) = DirectCast(Int16.Parse(txtMI1.Text), Object)
            values(2) = DirectCast(Int16.Parse(txtMI2.Text), Object)
        Catch
            System.Windows.Forms.MessageBox.Show("One of more of the values are not valid")
            Exit Sub
        End Try

        Dim wo As WriteOperands

        wo = New WriteOperands()

        With wo
            .OperandType = OperandTypes.MI
            .NumberOfOperands = 3
            .StartAddress = 0
            .Values = values
        End With

        Dim rw(0) As ReadWriteRequest
        rw(0) = wo

        Try
            plc.ReadWrite(rw)
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub ReadAsynch_Click(ByVal sender As Object, ByVal e As EventArgs) Handles ReadAsynch.Click
        Dim rw As ReadWriteRequest() = New ReadWriteRequest(0) {}
        Dim ro As ReadOperands

        ro = New ReadOperands()

        With ro
            .OperandType = OperandTypes.MI
            .NumberOfOperands = 3
            .StartAddress = 0
        End With

        rw(0) = ro

        Try
            plc.ReadWrite(rw, AddressOf AsyncReply)
        Catch
            System.Windows.Forms.MessageBox.Show("Could not communicate with the PLC")
        End Try
    End Sub

    Private Sub AsyncReply(ByVal ar As IAsyncResult)
        Dim async As AsyncResult
        async = DirectCast(ar, AsyncResult)
        Dim del As ReadWriteOperandsDelegate = DirectCast(async.AsyncDelegate, ReadWriteOperandsDelegate)
        Dim rw As ReadWriteRequest() = New ReadWriteRequest(-1) {}

        Try
            del.EndInvoke(rw, ar)
        Catch
            System.Windows.Forms.MessageBox.Show("Unexpected error")
            Exit Sub
        End Try

        Dim values As Object() = DirectCast((rw(0).ResponseValues), Object())

        For i As Integer = 0 To values.Length - 1
            If values(i) IsNot Nothing Then
                Dim txtbox As TextBox = TryCast(Me.groupBox1.Controls("txtMI" & i.ToString()), TextBox)
                SetControlPropertyValue(txtbox, "Text", CShort(values(i)).ToString())

                txtbox.Text = CShort(values(i)).ToString()
            End If
        Next
    End Sub

    Private Sub SetControlPropertyValue(ByVal oControl As Control, ByVal propName As String, ByVal propValue As Object)
        If oControl.InvokeRequired Then
            Dim d As New SetControlValueCallback(AddressOf SetControlPropertyValue)
            oControl.Invoke(d, New Object() {oControl, propName, propValue})
        Else
            Dim t As Type = oControl.[GetType]()
            Dim props As PropertyInfo() = t.GetProperties()
            For Each p As PropertyInfo In props
                If p.Name.ToUpper() = propName.ToUpper() Then
                    p.SetValue(oControl, propValue, Nothing)
                End If
            Next
        End If
    End Sub
End Class

